import java.net.*;
import java.io.*;



/*

	#############
	netio_httpclient class
	#############
	
	
	
	FUNCTION										USAGE
	###CONSTRUCTORS###
	netio_httpclient(String hostname, String username,				new HTTP client based on hostname, username, password and cryptLogin
	String password, boolean cryptLogin)
	
	###BASIC FUNCTIONS###
	login()											login using username and password - internal use only
	logout()										logout - internal use only
	command(String command)								send command to control interface
	sendCommand(String command)							sends command DIRECTLY - internal use by login()/logout() only
	
	###GET FUNCTIONS###
	getPorts()										get array with port states
	getPort(int port)									get single port state
	
	###SET FUNCTIONS###
	setPorts(int[] ports)									set all port states
	setPort(int port)									get single port state
	
	###DEBUG FUNCTIONS###
	getFix()										tells wether the logout-fix is enabled/disabled
	setFix(boolean bool)									enables/disables the logout-fix
	debugMsg(String msg)								sends a debug message - internal use only
	
*/



public class netio_httpclient
{
	
	
	
	String hostname, username, password;
	boolean cryptLogin;
	boolean loggedIn = false;
	boolean useFix = false;
	
	URL tgiURL;
	URLConnection tgi;
	
	
	
	/****************
	CONSTRUCTORS
	*****************/
	
	netio_httpclient(String hostname, String username, String password, boolean cryptLogin)
	/* new HTTP client based on hostname, username, password and cryptLogin */
	{
		debugMsg("New http client with hostname='" + hostname + "', username='" + username + "' and cryptLogin='" + cryptLogin + "'");
		this.hostname = hostname;
		this.username = username;
		this.password = password;
		this.cryptLogin = cryptLogin;
	}
	
	protected void finalize() throws Throwable
	/* destructor */
	{
		logout();
		super.finalize();
	}
	
	
	/*******************
	BASIC FUNCTIONS
	*******************/
	
	private void login() throws Exception
	/* login using username and password - internal use only */
	{
		debugMsg("About to login as '" + this.username + "'");
		String tempPrefix;
		if(this.cryptLogin == true) { tempPrefix = "c"; } else { tempPrefix = "p"; }
		if(sendCommand("login=" + tempPrefix + ":" + this.username + ":" + this.password).contains("100 HELLO")) { this.loggedIn = true; } else { this.loggedIn = false; }
	}
	
	private void logout() throws Exception
	/* logout - internal use only */
	{
		if(this.loggedIn == true) { sendCommand("quit=quit"); this.loggedIn = false; debugMsg("Logged out"); }
	}
	
	private String command(String command) throws Exception
	/* send command to control interface */
	{
		debugMsg("Execute command: '" + command + "'");
		if(this.loggedIn == false) { login(); }
		String temp = sendCommand(command);
		//logout if fix enabled and return result
		if(this.useFix == true) { logout(); }
		return temp;
	}
	
	private String sendCommand(String command) throws Exception
	/* sends command DIRECTLY - internal use by login()/logout() only */
	{
		//Setup URL and open connection
		String result;
		debugMsg("fetch URL result: 'http://" + this.hostname + "/tgi/control.tgi?" + command + "'");
		tgiURL = new URL("http://" + this.hostname + "/tgi/control.tgi?" + command);
		tgi = tgiURL.openConnection();
		tgi.setConnectTimeout(10000);
		tgi.setReadTimeout(10000);
		
		//Return result or die in a fire
		try
		{
			BufferedReader in = new BufferedReader(new InputStreamReader(tgi.getInputStream()));
			String temp = in.readLine();
			debugMsg("Got answer: '" + temp + "'");
			temp = temp.replace("<html>", "");
			temp = temp.replace("</html>", "");
			if(temp.contains("555 FORBIDDEN") == false) { result = temp; } else { result = "FAIL"; }
		}
		catch(Exception e)
		{
			result = "FAIL";
			debugMsg("Error while retrieving answer: " + e.getMessage());
		}
		return result;
	}
	
	
	
	/*****************
	GET FUNCTIONS
	*****************/
	
	public boolean[] getPorts() throws Exception
	/* get array with port states */
	{
		//Setup array and get result
		boolean[] tempPorts = new boolean[4];
		String temp = command("port=list");
		temp = temp.replace(" ", "");
		//Parse 0/1 and return array
		debugMsg("TEMP string: " + temp);
		for(int i=0;i<4;i++) {   if(temp.substring(i, i+1).equals("1")) { tempPorts[i] = true; } else { tempPorts[i] = false; }   }
		return tempPorts;
	}
	
	public boolean getPort(int port) throws Exception
	/* get single port state */
	{
		if(port >= 0 && port <= 4) { return getPorts()[port]; }
		else { return false; }
	}
	
	
	
	/*****************
	SET FUNCTIONS
	*****************/
	
	public boolean setPorts(int[] ports) throws Exception
	/* set all port states */
	{
		//set ports if 4 params given
		if(ports.length == 4)
		{
			if( command("port=" + ports[0] + "" + ports[1] + "" + ports[2] + "" + ports[3]).contains("250 OK") )
			{ return true; } else { return false; }
		}
		else { return false; }
	}
	
	public boolean setPort(int port, boolean state) throws Exception
	/* set single Port active/inactive */
	{
		//set port inactive if port 0-3
		if(port >= 0 && port <= 3)
		{
			//get current port states and convert to integer array
			boolean tempPorts[] = getPorts();
			int newPorts[] = new int[4];
			for(int i=0;i<4;i++)
			{  if(tempPorts[i] == true) { newPorts[i] = 1; } else { newPorts[i] = 0; }  }
			//set port state to be modified and return set result
			if(state == true) { newPorts[port] = 1; } else { newPorts[port] = 0; }
			return setPorts(newPorts);
		}
		else { return false; }
	}
	
	
	/********************
	DEBUG FUNCTIONS
	********************/
	
	public boolean getFix() { return this.useFix; }							//tells wether the logout-fix is enabled/disabled
	public void setFix(boolean bool) { this.useFix = bool; }						//enables/disables the logout-fix
	public void debugMsg(String msg) { System.out.println("HTTPClient: " + msg); }		//sends a debug message - internal use only
	
}