/*

	##############
	libjnetio example program
	##############
	
	2012 By Stankowic development
	info@stankowic-development.net
	http://netio.stankowic-development.net

*/



public class jnetio_example
{

	//configuration of your NETIO device
	String username = "admin";				//username
	String password = "your-admin-password";	//password
	String hostname = "192.168.1.100";		//hostname or IP address
	int port = 1234;						//KShell port
	boolean secLogin = false;				//Normal/secure login
	
	
	
	//ENABLE SOME SET FUNCTIONS AT THE BOTTOM OF THE CODE TO TEST - CHANGE PARAMETERS (SEE README)
	
	/*
	*********** END OF CONFIGURATION ***********
	*/
	
	//variables
	netio_client myNetio;
	
	
	
	public static void main(String[] args) throws Exception { jnetio_example test = new jnetio_example(); }
	
	jnetio_example() throws Exception
	{
		//instance new netio client and disable telnet fix temporarily
		myNetio = new netio_client(this.hostname, this.port, this.username, this.password, this.secLogin);
		myNetio.setTelnetFix(false);
		//myNetio.setTelnetFix(true);
		//if(myNetio.isLoggedIn() == true) { System.out.println("Login successful."); } else { System.out.println("Login NOT successful."); }
		
		//get hostname and version
		System.out.println("This NETIO has hostname '" + myNetio.getHostname() + "' and is version: " + myNetio.getVersion());
		
		//get network configuration
		System.out.println("\n*** NETWORK ***");
		String[] test = myNetio.getNetwork();
		for(int i=0;i<6;i++) { System.out.println(i + " - " + test[i]); }
		
		//get SNTP information
		System.out.println("\n*** SNTP ***");
		String[] sntp = myNetio.getSNTP();
		for(int i=0;i<3;i++) { System.out.println(i + ": " + sntp[i]); }
		
		//get port infos
		System.out.println("\n*** PORTS ***");
		String[][] ports = myNetio.getPorts();
		for(int i=0;i<4;i++)
		{
			System.out.println(i + " - state: " + ports[i][0]);
			System.out.println(i + " - name: " + ports[i][1]);
			System.out.println(i + " - timer/manual: " + ports[i][2]);
			System.out.println(i + " - delay: " + ports[i][0]);
		}
		
		//get port watchdogs information
		System.out.println("\n*** PORT WATCHDOGS ***");
		for(int i=0;i<4;i++)
		{
			String[] temp = myNetio.getPortWatchdog(i+1);
			System.out.println("Port #" + i + ": " + temp[0] + " "+ temp[1] + " "+ temp[2] + " "+ temp[3] + " "+ temp[4] + " "+ temp[5] + " "+ temp[6] + " "+ temp[7] + " ");
		}
		
		//get system discover information
		if(myNetio.getSystemDiscover() == true) { System.out.println("\nSystem discover: activated"); } else { System.out.println("\nSystem discover: deactivated"); }
		
		//get system delay information
		System.out.println("Power delay: " + myNetio.getPowerDelay());
		
		//get time/timezone information
		System.out.println("System time: " + myNetio.getTime());
		System.out.println("System timezone: " + myNetio.getTimezone());
		
		
		
		/******************\
		| SET FUNCTIONS |
		\******************/
		
		//set ports active/inactive
		/*myNetio.setPortActive(1);
		myNetio.setPortInactive(2);*/
		
		//set time and timezone
		/*myNetio.setTime("2011/11/11,11:11:11");
		myNetio.setTimezone("+1");*/
		
		
		//disable SNTP
		//System.out.println("\n*** SNTP ***");
		//myNetio.disableSNTP();
		//if(myNetio.getSNTPState() == true) { System.out.println("SNTP enabled."); } else { System.out.println("SNTP disabled."); }
		
		//set DNS
		/*myNetio.setDNS("192.168.1.111");
		System.out.println("DNS: " + myNetio.getDNS());*/
		
		//enable discovery
		/*myNetio.enableDiscover();
		if(myNetio.getSystemDiscover() == true) { System.out.println("\nSystem discover: activated"); } else { System.out.println("\nSystem discover: deactivated"); }*/
		
		//enable/disable watchdog
		/*myNetio.enableWatchdog(1);
		myNetio.disableWatchdog(2);*/
		
		//set power delay
		//myNetio.setPowerDelay(20);
		
		//set mailserver
		/*myNetio.setMailserver("mymailsrv.local");
		System.out.println("Mail server: " + myNetio.getMailserver());*/
		
		//Enable telnet fix and logout
		myNetio.setTelnetFix(true);
		myNetio.logout();
	
	}

}